/* eslint-disable @typescript-eslint/no-explicit-any */
// MOS SDK Type Definition File

declare global {
  interface Window {
    mos: MosSDK;
  }
}

export interface MosSDK {
  // 1.1 Basic Interfaces
  login(appKey: string): Promise<LoginResponse>;
  shareToApp(content: string): Promise<ShareResponse>;
  getUserInfo(options?: GetUserInfoOptions): Promise<GetUserInfoResponse>;
  getUserContactInfo(options?: GetUserContactInfoOptions): Promise<GetUserContactInfoResponse>;
  getSign(): Promise<GetSignResponse>;
  getLanguage(): Promise<GetLanguageResponse>;
  setShareLink(link: string): Promise<BaseResponse>;
  pay(options: PayOptions): Promise<PayResponse>;
  getWindowInfo(): Promise<GetWindowInfoResponse>;
  getAppBaseInfo(): Promise<GetAppBaseInfoResponse>;
  shareMiniApp(options?: ShareMiniAppOptions): Promise<ShareMiniAppResponse>;
  shareMiniAppData(options?: ShareMiniAppDataOptions): Promise<ShareMiniAppDataResponse>;
  // Explicitly declare getLaunchOptions method to fix type errors
  getLaunchOptions(): Promise<GetLaunchOptionsResponse>;
  addTrackingEvent(options: AddTrackingEventOptions): Promise<BaseResponse>;
  folderLinkClick(options: FolderLinkClickOptions): Promise<BaseResponse>;

  // 1.2 Device Interfaces
  scanCode(): Promise<ScanCodeResponse>;
  makePhoneCall(phoneNumber: string): Promise<BaseResponse>;
  setStatusbar(options?: SetStatusbarOptions): Promise<BaseResponse>;

  // 1.3 Location Interfaces
  getLocation(options?: GetLocationOptions): Promise<GetLocationResponse>;

  // 1.4 File Interfaces
  downNetFile(options: DownNetFileOptions): Promise<DownFileResponse>;
  downLocalFile(options: DownLocalFileOptions): Promise<DownFileResponse>;
}

// Base Response Interface
export interface BaseResponse {
  result?: 'SUCCESS' | 'FAILURE' | 'CANCEL' | 'NOWALLET';
}

// MOS SDK Error Interface
export interface MosError extends Error {
  result?: 'SUCCESS' | 'FAILURE' | 'CANCEL' | 'NOWALLET';
  [key: string]: any;
}

// Login Response
export interface LoginResponse extends BaseResponse {
  code: string;
}

// Get User Info Response
export interface GetUserInfoResponse extends BaseResponse {
  authorized: number; // 0: Not authorized | 1: Authorized | 2: No corresponding information
  firstName?: string;
  lastName?: string;
  headPortrait?: string;
  descriptor?: string;
}

// Get User Contact Info Response
export interface GetUserContactInfoResponse extends BaseResponse {
  authorized: number;
  dialCode?: string;
  phone?: string;
  email?: string;
}

// Get Sign Response
export interface GetSignResponse extends BaseResponse {
  sign: string;
}

// Get Language Response
export interface GetLanguageResponse extends BaseResponse {
  lang: string;
}

// Pay Options
export interface PayOptions {
  amount: string;
  currency: 'USD' | 'KHR';
  appKey: string;
  prepayId: string;
}

// Pay Response
export interface PayResponse extends BaseResponse {
  data?: string;
}

// Get Window Info Response
export interface GetWindowInfoResponse extends BaseResponse {
  statusBarHeight: number;
}

// Get App Base Info Response
export interface GetAppBaseInfoResponse extends BaseResponse {
  platform: 'IOS' | 'ANDROID';
  SDKVersion: string;
  language: string;
  version: string;
  deviceId: string;
  brand: string;
  system: string;
}

// Share Mini App Options
export interface ShareMiniAppOptions {
  query?: string | Record<string, any>;
  shareDisabled?: string; // 1: Disabled | 0: Enabled
  desc?: string;
  imageUrl?: string;
  screenShotDisabled?: string; // 1: Screenshot disabled | 0: Auto screenshot
}

// Share Mini App Response
export interface ShareMiniAppResponse extends BaseResponse {
  shareLink: string;
}

// Share Mini App Data Options
export interface ShareMiniAppDataOptions {
  query?: string | Record<string, any>;
  shareDisabled?: string;
  desc?: string;
  imageUrl?: string;
  screenShotDisabled?: string;
}

// Share Mini App Data Response
export interface ShareMiniAppDataResponse extends BaseResponse {
  shareLink: string;
}

// Get Launch Options Response
export interface GetLaunchOptionsResponse extends BaseResponse {
  query: string | Record<string, any>;
}

// Add Tracking Event Options
export interface AddTrackingEventOptions {
  name: string;
  data?: string;
}

// Folder Link Click Options
export interface FolderLinkClickOptions {
  link: string;
  query?: Record<string, any>;
}

// Scan Code Response
export interface ScanCodeResponse extends BaseResponse {
  code: string;
}

// Set Statusbar Options
export interface SetStatusbarOptions {
  show?: string; // 1: Show | 0: Hide
  style?: 'dark' | 'light'; // dark: Black | light: White
}

// Get Location Options
export interface GetLocationOptions {
  isHighAccuracy?: string; // 1: Enable | 0: Disable
  highAccuracyExpireTime?: string; // High precision location timeout time(ms)
}

// Get Location Response
export interface GetLocationResponse extends BaseResponse {
  latitude: string;
  longitude: string;
  address: string;
  speed: string;
  accuracy: string;
  altitude: string;
  verticalAccuracy: string;
  horizontalAccuracy: string;
}

// Download Network File Options
export interface DownNetFileOptions {
  fileUrl: string;
  fileName?: string;
  fileExt?: string;
  showLoading?: string; // 1: Show 0: Hide
  showMsg?: string; // 1: Show 0: Hide
}

// Download Local File Options
export interface DownLocalFileOptions {
  file: File;
  fileName?: string;
  fileExt?: string;
  showLoading?: string;
  showMsg?: string;
}

// Download File Response
export interface DownFileResponse extends BaseResponse {
  message?: string;
  data?: string;
}

// Get User Info Options
export interface GetUserInfoOptions {
  authorizedDesc?: string;
  closeOnClickOverlay?: string; // 0: Don't close 1: Close
}

// Get User Contact Info Options
export interface GetUserContactInfoOptions {
  authorizedDesc?: string;
  closeOnClickOverlay?: string;
}

export {};