import { ref } from 'vue'
import { defineStore } from 'pinia'
import { getUserInfoApi, saveUserInfoApi } from '@/api'

export const useUserStore = defineStore('user', () => {
  const token = ref(localStorage.getItem('token') || '')
  const userInfo = ref()

  async function getUserInfo() {
    const res = await getUserInfoApi()
    setUserInfo(res.data)
  }

  function setUserInfo(newUserInfo: {
    authResult: number
    firstName: string
    lastName: string
    headPortrait: string
    description: string
  }) {
    let fullName = ''
    if (newUserInfo.firstName && newUserInfo.lastName) {
      fullName = `${newUserInfo.firstName} ${newUserInfo.lastName}`
    } else {
      fullName = newUserInfo.firstName || newUserInfo.lastName || ''
    }
    userInfo.value = {
      authResult: newUserInfo.authResult,
      firstName: newUserInfo.firstName,
      lastName: newUserInfo.lastName,
      headPortrait: newUserInfo.headPortrait,
      description: newUserInfo.description,
      fullName
    }
  }
  async function saveUserInfo(newUserInfo: {
    authResult: number
    firstName: string
    lastName: string
    headPortrait: string
    description: string
  }) {
    await saveUserInfoApi(newUserInfo)
  }
  function setToken(newToken: string) {
    token.value = newToken
    localStorage.setItem('token', newToken)
  }

  function logout() {
    userInfo.value = null
    token.value = ''
    localStorage.removeItem('token')
  }

  return { userInfo, token, getUserInfo, setUserInfo, saveUserInfo, setToken, logout }
})
