import { ref } from 'vue'
import { defineStore } from 'pinia'

export const useAppStore = defineStore('app', () => {
  const statusBarHeight = ref(0)
  const isFullScreen = ref(false)
  function setStatusBarHeight(height: number) {
    statusBarHeight.value = height
  }

  function setIsFullScreen(isShow: boolean) {
    isFullScreen.value = isShow
  }

  return { statusBarHeight, isFullScreen, setStatusBarHeight, setIsFullScreen }
})
