import { createRouter, createWebHistory } from 'vue-router'
import Features from '@/views/Features.vue'
import Profile from '@/views/Profile.vue'
import { useUserStore } from '@/stores/user'
import { loginApi } from '@/api'
import type {
  MosSDK
} from '@/types/mos-sdk'
declare const mos: MosSDK
const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/',
      redirect: '/features'
    },
    {
      path: '/features',
      name: 'Features',
      component: Features
    },
    {
      path: '/profile',
      name: 'Profile',
      component: Profile
    }
  ],
})

let appSign = ''
let isLogin = false

router.beforeEach(async (_to, _from, next) => {
  try {
		// First check if token exists, if not, proceed with login flow; if token exists but it's not the current user, re-login is required
		if (!appSign) {
			const res = await mos.getSign()
			appSign = String(res.sign)
		}
    const userStore = useUserStore()
		const sign = localStorage.getItem('sign')
		console.log('Local sign:', sign)
		// If sign is the same and token exists, it means already logged in
		if (sign && sign === appSign && userStore.token) {
			isLogin = true
		}
		console.log('Logged in before:', isLogin)
		if (!isLogin) {
			console.log('Not logged in, auto-login in progress:')
			const res = await mos.login(import.meta.env.VITE_APP_KEY)
      const loginRes = await loginApi(res.code)
      userStore.setToken(loginRes.data.token)
			localStorage.setItem('sign', appSign)
			console.log('Auto-login successful')
		}
	} catch (error) {
		console.error('beforeEach error:', error)
	}
	next()
})

export default router