import { createI18n } from 'vue-i18n'

import zhLocale from '../locales/zh.json'
import enLocale from '../locales/en.json'

const i18n = createI18n({
  legacy: false,
  locale: localStorage.getItem('language') || 'en-US',
  fallbackLocale: 'en-US',
  messages: {
    'zh-CN': zhLocale,
    'en-US': enLocale
  }
})

export default i18n
