/* eslint-disable @typescript-eslint/no-explicit-any */
import { useUserStore } from '@/stores/user'

export const request = async (url: string, options: RequestInit = {}) => {
  const token = useUserStore().token
  const defaultOptions: RequestInit = {
    headers: {
      'Content-Type': 'application/json',
      Authorization:  token ? `Bearer ${token}` : '',
      ...options.headers,
    },
  }

  const config: RequestInit = {
    ...defaultOptions,
    ...options,
  }

  try {
    const response = await fetch(import.meta.env.VITE_BASE_URL + url, config)

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`)
    }

    const data = await response.json()
    return data
  } catch (error) {
    console.error('Request failed:', error)
    throw error
  }
}

export const get = (url: string, options?: RequestInit) =>
  request(url, { method: 'GET', ...options })

export const post = (url: string, data?: any, options?: RequestInit) =>
  request(url, {
    method: 'POST',
    body: JSON.stringify(data),
    ...options
  })

export const put = (url: string, data?: any, options?: RequestInit) =>
  request(url, {
    method: 'PUT',
    body: JSON.stringify(data),
    ...options
  })

export const del = (url: string, options?: RequestInit) =>
  request(url, { method: 'DELETE', ...options })
